/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.measuring.IMeasuringTapeItem;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.BlockHitResultUtils;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.keys.KeyBindingManager;
import mod.chiselsandbits.measures.MeasuringManager;
import mod.chiselsandbits.network.packets.MeasurementsResetPacket;
import mod.chiselsandbits.platforms.core.dist.Dist;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeasuringTapeItem
extends class_1792
implements IMeasuringTapeItem {
    public MeasuringTapeItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    @NotNull
    public MeasuringMode getMode(class_1799 stack) {
        if (!stack.method_7948().method_10545("mode")) {
            return MeasuringMode.WHITE_BIT;
        }
        return MeasuringMode.valueOf(stack.method_7948().method_10558("mode"));
    }

    @Override
    public void setMode(class_1799 stack, MeasuringMode mode) {
        if (mode == null) {
            return;
        }
        stack.method_7948().method_10582("mode", mode.toString());
    }

    @Override
    @NotNull
    public Collection<MeasuringMode> getPossibleModes() {
        return Lists.newArrayList((Object[])MeasuringMode.values());
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(class_1657 playerEntity, class_1268 hand, class_2338 position, class_2350 face, ClickProcessingState currentState) {
        ClickProcessingState result = ClickProcessingState.DEFAULT;
        class_1799 stack = playerEntity.method_5998(hand);
        if (stack.method_7909() == this) {
            if (((Boolean)DistExecutor.unsafeRunForDist(() -> () -> KeyBindingManager.getInstance().isResetMeasuringTapeKeyPressed(), () -> () -> false)).booleanValue()) {
                this.clear(stack);
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new MeasurementsResetPacket());
            } else {
                class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
                if (rayTraceResult.method_17783() == class_239.class_240.field_1332 && rayTraceResult instanceof class_3965) {
                    class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
                    Optional<class_243> startPointHandler = this.getStart(stack);
                    if (startPointHandler.isEmpty()) {
                        this.setStart(stack, this.getMode(stack).getType().adaptClickedPosition(blockRayTraceResult));
                    } else {
                        class_243 startPoint = startPointHandler.get();
                        class_243 hitVector = BlockHitResultUtils.getCenterOfHitObject(blockRayTraceResult, this.getMode(stack).getType().getResolution());
                        MeasuringManager.getInstance().createAndSend(startPoint, this.getMode(stack).getType().adaptClickedPosition(blockRayTraceResult), blockRayTraceResult.method_17780(), this.getMode(stack));
                        this.clear(stack);
                    }
                    result = ClickProcessingState.ALLOW;
                }
            }
        }
        return result;
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 worldIn, @NotNull class_1297 entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.method_8608()) {
            return;
        }
        if (!(entityIn instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)entityIn;
        if (stack.method_7909() != this) {
            return;
        }
        Optional<class_243> startPointHandler = this.getStart(stack);
        if (startPointHandler.isEmpty()) {
            return;
        }
        if (KeyBindingManager.getInstance().isResetMeasuringTapeKeyPressed()) {
            this.clear(stack);
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new MeasurementsResetPacket());
            return;
        }
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            return;
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 hitVector = blockRayTraceResult.method_17784();
        class_243 startPoint = startPointHandler.get();
        MeasuringManager.getInstance().createAndSend(startPoint, this.getMode(stack).getType().adaptClickedPosition(blockRayTraceResult), blockRayTraceResult.method_17780(), this.getMode(stack));
    }

    @Override
    @NotNull
    public Optional<class_243> getStart(@NotNull class_1799 stack) {
        if (!stack.method_7948().method_10545("start")) {
            return Optional.empty();
        }
        class_2487 start = stack.method_7948().method_10562("start");
        return Optional.of(new class_243(start.method_10574("x"), start.method_10574("y"), start.method_10574("z")));
    }

    @Override
    public void setStart(@NotNull class_1799 stack, @NotNull class_243 start) {
        class_2487 compoundNBT = new class_2487();
        compoundNBT.method_10549("x", start.method_10216());
        compoundNBT.method_10549("y", start.method_10214());
        compoundNBT.method_10549("z", start.method_10215());
        stack.method_7948().method_10566("start", (class_2520)compoundNBT);
    }

    @Override
    public void clear(@NotNull class_1799 stack) {
        stack.method_7948().method_10551("start");
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> {
            if (KeyBindingManager.getInstance().hasBeenInitialized()) {
                HelpTextUtils.build(LocalStrings.HelpTapeMeasure, tooltip, class_310.method_1551().field_1690.field_1904.method_16007(), class_310.method_1551().field_1690.field_1904.method_16007(), KeyBindingManager.getInstance().getResetMeasuringTapeKeyBinding().method_16007(), KeyBindingManager.getInstance().getOpenToolMenuKeybinding().method_16007());
            }
        });
    }
}

